#ifndef __LINUX_I2C_TSC2013_H
#define __LINUX_I2C_TSC2013_H

/* linux/i2c/tsc2013.h */

struct tsc2013_platform_data {
	u16	model;				/* 2013 */
    u16	x_plate_ohms;
		
	unsigned long poll_delay; /* delay (in ms) after pen-down event before polling starts */
	unsigned long poll_period; /* time (in ms) between samples */
	int	fuzzx; /* fuzz factor for X, Y and pressure axes */
	int	fuzzy;
	int	fuzzz;
	
	int	(*get_pendown_state)(void);
	void (*clear_penirq)(void);		/* If needed, clear 2nd level
						   interrupt source */
	int	(*init_platform_hw)(void);
	void (*exit_platform_hw)(void);
};

#endif
